*Exploration of missing values of ESEC

*July 2019

*Tim Goedemé

/*

*The output of this do-file is not used in the article. 
For results, see rather the research note:
Goedemé, 2019, A note on the replication of the European Socio-economic 
Classification (ESeC) in the EU Statistics on Income and Living Conditions 
(EU-SILC). INET Oxford Working Paper No. 2019-17, Oxford: Institute for New 
Economic Thinking at the Oxford Martin School, University of Oxford.


Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. 
This file can be changed and re-shared for non-commercial use, as long as our original work 
is recognised and the revised work is made available under the same conditions.

When using this do-file, please cite as:
Goedemé, T., Nolan, B., Paskov, M., & Weisstanner, D. (2021). 
Occupational Social Class and Earnings Inequality in Europe: A Comparative Assessment. 
In: Social Indicators Research. DOI: https://doi.org/10.1007/s11205-021-02746-z; https://timgoedeme.com/tools/esec-in-eu-silc/


*/

global place1 <<data directory>>
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IS IT LT LU LV MT NL NO PL PT RO RS SE SI SK UK


********************
*Some further tests*
********************



*1. Check how percentage with esec value varies over time and countries among active population at working age

global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IS IT LT LU LV MT NL NO PL PT RO RS SE SI SK UK

global select DK FI IS NL NO SE SI
local varlist esec88 esec08
foreach v of local varlist {
	di "***`v'***"
	di "****************"
	cap mat drop res_`v'1
	cap mat drop res_`v'2
	
	foreach ctry of global countries {
		di "`ctry'", _continue
		
		cap mat drop tempmat1
		cap mat drop tempmat2
		quietly {
			
			if "`v'"=="esec88" {
				forvalues year=2004(1)2011 {
					di "`ctry': `year'"
					local val1=.
					local val2=.
					cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
					
					if _rc==0 {
						use "${place1}\`ctry'\\`year'\c`ctry'`year'_ESEC.dta", clear
						merge 1:1 country hid pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
						gen ok=(`v'!=.)
						noi di ustrregexm("${select}", "`ctry'"), _continue
						if ustrregexm("${select}", "`ctry'") == 0 cap sum ok if year==`year' & actage==1 & active==1
						else cap sum ok if year==`year' & actage==1 & active==1 & px040==2
						local val1 = r(mean)
						local val2 = r(sum)
							
					}
					mat def tempmat1 = nullmat(tempmat1) , `val1'
					mat def tempmat2 = nullmat(tempmat2) , `val2'
				}
			
			}
			
			else {
			    cap mat drop tempmat1
				cap mat drop tempmat2
				forvalues year=2010(1)2018 {
					local val=.
					cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
					
					if _rc==0 {
						use "${place1}\`ctry'\\`year'\c`ctry'`year'_ESEC.dta", clear
						merge 1:1 country hid pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
						gen ok=(`v'!=.)
						noi di ustrregexm("${select}", "`ctry'"), _continue
						if ustrregexm("${select}", "`ctry'") == 0 cap sum ok if year==`year' & actage==1 & active==1
						else cap sum ok if year==`year' & actage==1 & active==1 & px040==2
						local val1 = r(mean)
						local val2 = r(sum)
							
					}
					mat def tempmat1 = nullmat(tempmat1) , `val1'
					mat def tempmat2 = nullmat(tempmat2) , `val2'
				}
			}
		}
		mat def res_`v'1 = nullmat(res_`v'1) \ tempmat1
		mat def res_`v'2 = nullmat(res_`v'2) \ tempmat2
	}
	mat rownames res_`v'1 = $countries
	mat rownames res_`v'2 = $countries
	if "`v'"=="esec88" | "`v'"=="esec883" mat colnames res_`v'1 = 2004 2005 2006 2007 2008 2009 2010 2011
	else mat colnames res_`v'1 = 2010 2011 2012 2013 2014 2015 2016 2017 2018
	
	if "`v'"=="esec88" | "`v'"=="esec883" mat colnames res_`v'2 = 2004 2005 2006 2007 2008 2009 2010 2011
	else mat colnames res_`v'2 = 2010 2011 2012 2013 2014 2015 2016 2017 2018
}
foreach v of local varlist {
	di "***`v'***"
	mat li res_`v'1
	mat li res_`v'2
}


*1. Same, but now for self-employed only

global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IS IT LT LU LV MT NL NO PL PT RO RS SE SI SK UK

global select DK FI IS NL NO SE SI
local varlist esec88 esec08
foreach v of local varlist {
	di "***`v'***"
	di "****************"
	cap mat drop res_`v'1
	cap mat drop res_`v'2
	
	foreach ctry of global countries {
		di "`ctry'", _continue
		
		cap mat drop tempmat1
		cap mat drop tempmat2
		quietly {
			
			if "`v'"=="esec88" {
				forvalues year=2004(1)2011 {
					di "`ctry': `year'"
					local val1=.
					local val2=.
					cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
					
					if _rc==0 {
						use "${place1}\`ctry'\\`year'\c`ctry'`year'_ESEC.dta", clear
						merge 1:1 country hid pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
						gen ok=(`v'!=.)
						noi di ustrregexm("${select}", "`ctry'"), _continue
						if ustrregexm("${select}", "`ctry'") == 0 cap sum ok if year==`year' & actage==1 & active==1 & pl040<3
						else cap sum ok if year==`year' & actage==1 & active==1 & px040==2 & pl040<3
						local val1 = r(mean)
						local val2 = r(sum)
							
					}
					mat def tempmat1 = nullmat(tempmat1) , `val1'
					mat def tempmat2 = nullmat(tempmat2) , `val2'
				}
			
			}
			
			else {
			    cap mat drop tempmat1
				cap mat drop tempmat2
				forvalues year=2010(1)2018 {
					local val=.
					cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
					
					if _rc==0 {
						use "${place1}\`ctry'\\`year'\c`ctry'`year'_ESEC.dta", clear
						merge 1:1 country hid pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
						gen ok=(`v'!=.)
						noi di ustrregexm("${select}", "`ctry'"), _continue
						if ustrregexm("${select}", "`ctry'") == 0 cap sum ok if year==`year' & actage==1 & active==1 & pl040<3
						else cap sum ok if year==`year' & actage==1 & active==1 & px040==2 & pl040<3
						local val1 = r(mean)
						local val2 = r(sum)
							
					}
					mat def tempmat1 = nullmat(tempmat1) , `val1'
					mat def tempmat2 = nullmat(tempmat2) , `val2'
				}
			}
		}
		mat def res_`v'1 = nullmat(res_`v'1) \ tempmat1
		mat def res_`v'2 = nullmat(res_`v'2) \ tempmat2
	}
	mat rownames res_`v'1 = $countries
	mat rownames res_`v'2 = $countries
	if "`v'"=="esec88" | "`v'"=="esec883" mat colnames res_`v'1 = 2004 2005 2006 2007 2008 2009 2010 2011
	else mat colnames res_`v'1 = 2010 2011 2012 2013 2014 2015 2016 2017 2018
	
	if "`v'"=="esec88" | "`v'"=="esec883" mat colnames res_`v'2 = 2004 2005 2006 2007 2008 2009 2010 2011
	else mat colnames res_`v'2 = 2010 2011 2012 2013 2014 2015 2016 2017 2018
}
foreach v of local varlist {
	di "***`v'***"
	mat li res_`v'1
	mat li res_`v'2
}




